<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */
 
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$this->load->helper('form');
?>
<script>
	var which_report = 'points_of_origin';
	$(function() {
		$('[id^=details-modal]').dialog({ autoOpen: false })
		$('[id^=details-link]').click(function(e){
			e.preventDefault();
			var id = $(e.target).attr('id').replace('details-link','');
			$('[id^=details-modal]').dialog({
				modal:true,
				width:460,
				height:500
			});
			$('[id=details-modal'+id+']').dialog('open');
		});
		
		$('[id^=details-modal]').on('click', '#close_pop_up', function(){
			$(this).closest('[id^=details-modal]').dialog('close');
		});
	});
</script>
				<h1>Points of Origin</h1>
				<div class="column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<?php echo $tabs;?>
						</ul>
					<div class="tab-content">
						<p>This table lists the count of total messages sent, grouped by originating applications.</p>
						<?PHP $this->load->view('api/reports/adhoc_Reports/adhoc_report_info'); ?>
						<?PHP echo form_open('/reports/points_of_origin',array('id'=>'reports_form','onsubmit'=>"javascript:submitPaginationForm('', 1, ".$form_data['items_per_page'].", '');")); ?>
							<table class="form">
								<tr class="form_row">
									<td>Application:</td>
									<td>
										<select class="fill_row" id="application_id" name="application_id" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<?php foreach($apps as $app){ ?>
											<option value="<?php echo $app->id;?>" <?php if (isset($form_data['application_id']) && $app->id==$form_data['application_id']){echo "selected";}?>><?php echo $app->name;?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>
								<tr class="form_row">
									<td>Start Date:</td>
									<td><input type="text" id="start_date" name="start_date" class="date" value="<?php if(isset($form_data['start_date'])) { echo htmlentities($form_data['start_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
									<td>&nbsp;</td>
									<td>End Date:</td>
									<td><input type="text" id="end_date" name="end_date" class="date" value="<?php if(isset($form_data['end_date'])) { echo htmlentities($form_data['end_date']); } ?>" onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt", timeSuffix: ' '+timezone_abbr});</script>
							</table>
							<?PHP
								$export_file_name = 'Point of Origin Report';
								if (isset($form_data['report_name'])){
									$export_file_name = $form_data['report_name'];
								}
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'export_pdf' => '0',
									'print_page' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
									'export_file_name' => $export_file_name,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>
								<input class="blue-button" id="details-link" name="details-link" type="submit" value="Save Report"></input>
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							<div id="date_error_message" class="message_error" style="display: none;"></div>
							<?php if(sizeof($message_counts) == 0) { ?>
								<div class="message">There is currently no point of origin information available.</div>
							<?php }else{ 
								if(!empty($form_data['date_warning_message'])) { ?>
									<div class="message"><?php echo $form_data['date_warning_message']; ?></div>
								<?PHP } ?>
								<?php if(sizeof($message_counts) > 0) { ?>
									<div class="pagination">
										<?php echo $form_data['pages']->display_result_num();?>
										<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
										<?php echo $form_data['pages']->display_items_per_page();?>
										<div style="float:right; position: relative;">
											<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
												<a href="#" onclick="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP } 
											else { ?>
												<a href="#" onclick="if ( confirm('You are going to export <?php echo $form_data['pages']->items_total; ?> records and this will take a few minutes. Are you sure you want to proceed?')){ $('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');}"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
											<?PHP } ?>
											<a id="export_pdf" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
											<a href="#"  onclick="submitPaginationForm('<?php echo $form_data['cur_page'];?>', '', '<?php echo $form_data['items_per_page'];?>', '', '', 1);"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
											<label class="hidden_context">Page Selector</label>
											<input id="page_select" class="page_selector_input" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
											<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
										</div>
									</div>
								<?php }?>
							<?php }?> 
						<?PHP echo form_close(); ?>
						<?PHP echo form_open('/reports/points_of_origin',array('id'=>'clear_form')); echo form_close(); 
							if(sizeof($message_counts) > 0) {
								$this->load->view('api/reports/result_tables/result_points_of_origin');
						?>
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page();?>
								<div style="float:right; position: relative;">
									<?PHP if ($form_data['pages']->items_total <= 1000) { ?>
										<a href="#" onclick="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP } 
									else { ?>
										<a href="#" onclick="if ( confirm('You are going to export <?php echo $form_data['pages']->items_total; ?> records and this will take a few minutes. Are you sure you want to proceed?')){ $('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');}"><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"  /></a>
									<?PHP } ?>
									<a id="export_pdf" class="export_pdf"  href="#" ><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"/></a>
									<a href="#"  onclick="submitPaginationForm('<?php echo $form_data['cur_page'];?>', '', '<?php echo $form_data['items_per_page'];?>', '', '', 1);"><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"  /></a>
									<label class="hidden_context">Page Selector</label>
									<input id="page_select" class="page_selector_input" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
							<?php }?> 
							
						</div>
					
					</div>
				</div>
			</div>
			<?php $this->load->view('api/reports/result_tables/file_downloading_window');?>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
		<div id="details-modal" title="Save Current Report">
			<div class="adhoc_report">
				<?PHP 
					$this->load->view('api/reports/adhoc_reports/adhoc_points_of_origin');
				?>
			</div>
		</div>
	</body>
</html>
